#!/bin/bash

# Set the problem name to generate correct file names
PROBLEMNAME="killingchaos"

# Set this if you want to generate answers.
# g++ -O2 submissions/accepted/sol.cpp -o /tmp/a.out
cp ../../submissions/accepted/torstein_nlogstarn.py /tmp/sol.py
SOLVER=/tmp/sol.py
MAXN=100000

subfolders=(a_small b_big) # (folderA folderB folderC)
for i in ${subfolders[@]}
do
    rm -r $i
    if [ ! -d $i ]
    then
        mkdir $i
    fi
done

COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gendata.py -s $COUNT -n $1 -o $2 > $DR/${padCount}_n$1_$2.in
}

echo "Generating dataset 1... (generated)"

DR="a_small"
generate 3 random
generate 3 even
generate 3 maxeven
generate 9 random
generate 9 even
generate 9 max
generate 9 maxeven
generate 10 random
generate 10 even
generate 10 max
generate 10 maxeven
generate 10 odd
generate 10 oddrev
generate 10 evenrev
generate 10 third
generate 11 third

DR="b_big"
generate $MAXN random
generate $MAXN random
generate $MAXN even
generate $MAXN odd
generate $MAXN evenrev
generate $MAXN oddrev
generate $MAXN max
generate $MAXN maxeven
generate $MAXN fiswap
generate $MAXN laswap
generate $MAXN filaswap
generate $MAXN filaswaprev
generate $MAXN fiswaprev
generate $MAXN laswaprev
generate $MAXN inc
generate $MAXN increv
generate $MAXN third
generate $(($MAXN - 1)) random
generate $(($MAXN - 1)) random
generate $(($MAXN - 1)) odd
generate $(($MAXN - 1)) even
generate $(($MAXN - 1)) oddrev
generate $(($MAXN - 1)) evenrev
generate $(($MAXN - 1)) max
generate $(($MAXN - 1)) maxeven
generate $(($MAXN - 1)) third


# generate solutions for all files
if [[ ! -z $SOLVER ]]
then
    for i in ${subfolders[@]}
    do
        for f in $i/*.in
        do
            echo "solving $f"
            $SOLVER < $f > ${f%???}.ans
        done
    done
fi
