#!/usr/bin/env python3
from heapq import heappop as pop
from heapq import heappush as push

KEY = "Jane Eyre"
n, m, k = [int(x) for x in input().split()]

pq = [(KEY, k)]

for _ in range(n):
    line = input()
    li, ri = line.index('"'), line.rindex('"')
    book = line[li+1:ri]
    pages = int(line[ri+1:].strip())
    push(pq, (book, int(pages)))
    
events = []
for _ in range(m):
    line = input()
    li, ri = line.index('"'), line.rindex('"')
    book = line[li+1:ri]
    time = int(line[:li].strip())
    pages = int(line[ri+1:].strip())
    events.append((int(time), (book, int(pages))))    
events.sort(key=lambda x: -x[0])

time = 0
while True:
    if len(events) > 0 and events[-1][0] <= time:
        push(pq, events[-1][1])
        events.pop()

    book, pages = pop(pq)
    time += pages
    if book == KEY:
        break
        
print(time)
    
    