#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

using namespace std;

typedef long long LL;
#define rep(i,n) for(int i=0;i<(n);i++)

struct book {
    string title;
    LL pages, arrive;
};

bool compareByTime(const book& a, const book& b) {
    return a.arrive < b.arrive;
}

int main() {
    ios::sync_with_stdio(false); // Speedup (do not mix with scanf/prinf)
    cin.tie(NULL); // Speedup (do not mix with scanf/prinf)

    int n, m, k;
    cin >> n >> m >> k;
    string line;
    getline(cin, line);
    
    book target = { .title = "Jane Eyre", .pages = k, .arrive = 0 };
    char del = '\"';
    vector<book> pile;
    
    rep(i, n + m) {
        getline(cin, line);
        int fi = line.find(del);
        int la = line.find_last_of(del);
        string title = line.substr(fi + 1, la - fi - 1);
        if (title.compare(target.title) < 0) {
            LL a = (i >= n) ? stoi(line.substr(0, fi - 1)) : 0LL;
            book b = { .title = title, .pages = stoi(line.substr(la + 1)), .arrive = a};
            pile.push_back(b);
        }
    }
    
    sort(pile.begin(), pile.end(), compareByTime);
    
    LL time = 0LL;
    for (const book b : pile) {
        if (time < b.arrive) break;
        time += b.pages;
    }

    cout << (time + target.pages) << endl;
}
