#!/bin/bash

# Set the problem name to generate correct file names
PROBLEMNAME="janeeyre"

# Set this if you want to generate answers.
# g++ -O2 submissions/accepted/sol.cpp -o /tmp/a.out
cp ../../submissions/accepted/torstein_nlogn.py /tmp/sol.py
SOLVER=/tmp/sol.py
MAXN=100000
MAXM=100000

subfolders=(generated) # (folderA folderB folderC)
for i in ${subfolders[@]}
do
    rm -r $i
    if [ ! -d $i ]
    then
        mkdir $i
    fi
done

COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gendata.py -s $COUNT -n $1 -m $2 -o $3 > $DR/${padCount}_n$1_m$2_$3.in
}

echo "Generating dataset 1... (generated)"
DR="generated"

generate 10 10 random
generate 10 10 AA
generate 10 10 aa
generate 10 10 AZ
generate 10 10 AJ
generate 10 10 space
generate 100 100 random
generate 100 100 random
generate 1000 1000 random
generate 1000 1000 random
generate 10000 10000 random
generate 10000 10000 random
generate 10000 10000 AA
generate 10000 10000 aa
generate 10000 10000 AZ
generate 10000 10000 AJ
generate 10000 10000 space
generate 100000 100000 random
generate 100000 100000 random
generate 100000 100000 AJ
generate 100000 100000 aa


# generate solutions for all files
if [[ ! -z $SOLVER ]]
then
    for i in ${subfolders[@]}
    do
        for f in $i/*.in
        do
            echo "solving $f"
            $SOLVER < $f > ${f%???}.ans
        done
    done
fi
