#!/usr/bin/env python3
import sys, argparse, random

parser = argparse.ArgumentParser(description="Generator for janeeyre.")    
parser.add_argument('-n', metavar='N', type=int, required=True,
                    help='number of books')
parser.add_argument('-m', metavar='m', type=int, default=None,
                    help='duration of stay')
parser.add_argument('-o', metavar='O', type=str, default="random",
                    help='options')
parser.add_argument('-s', metavar='S', type=int, default=None,
                    help='seed')
args = parser.parse_args()
random.seed(args.s)

MAXK = 100000
MAXT = 1000000000
MAXSIZ = 20
ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz   "

n = args.n
m = args.m
options = args.o

seen = set()
pile = []
gifts = []

def randString(siz):
    return "".join(random.choice(ALPHABET) for _ in range(siz))
    
def fillStartWith(startlist):
    for _ in range(n):
        start = random.choice(startlist)
        title = '"' + start + randString(MAXSIZ-len(start)) + '"'
        while title in seen:
            title = '"' + start + randString(MAXSIZ-len(start)) + '"'
            
        seen.add(title)
        pile.append((title, str(random.randrange(1, MAXK))))
        
    for _ in range(m):
        start = random.choice(startlist)
        title = '"' + start + randString(MAXSIZ-len(start)) + '"'
        while title in seen:
            title = '"' + start + randString(MAXSIZ-len(start)) + '"'
            
        seen.add(title)
        gifts.append((str(random.randrange(MAXT)), title, str(random.randrange(1, MAXK))))
        

if "AA" in options:
    fillStartWith(["A"])
        
elif "aa" in options:
    fillStartWith(["a"])
    
elif "AZ" in options:
    fillStartWith(list("ABCDEFGHIJKLMNOPQRSTUVWXYZ"))
    
elif "AJ" in options:
    fillStartWith(list("ABCDEFGHIJ"))
    
elif "space" in options:
    fillStartWith(list("    ABCDEFGHIJKLMNO"))
    
else:
    fillStartWith([""])


print(n, m, random.randrange(1, MAXK))
random.shuffle(pile)
random.shuffle(gifts)
print("\n".join("{} {}".format(a, b) for a, b in pile))
print("\n".join("{} {} {}".format(a, b, c) for a, b, c in gifts))
