#!/usr/bin/env python2
import sys
import re

args = sys.argv
infile = list(open(args[1]))
# anfile = list(open(args[2]))

# Find minimum length of answer
n = len(infile[0].strip())

data = sys.stdin.read().strip()
        
# Long enough
if len(data) <= n:
    sys.exit(43)
    
# Correct characters
if not re.match('^[AHOW]*$', data):
    sys.exit(43)
    
# No illegal sequences
for seq in ["WW", "HH", "HW", "HA"]:
    if seq in data:
        sys.exit(43)
        
# required characters
for c in "AHOW":
    if c not in data:
        sys.exit(43)
        
if "A" in data and "O" in data:
    if data.rindex("A") >= data.index("O"):
        sys.exit(43)
    
sys.exit(42)
