import itertools

def powerset(iterable):
    "powerset([1,2,3]) --> () (1,) (2,) (3,) (1,2) (1,3) (2,3) (1,2,3)"
    s = list(iterable)
    return itertools.chain(itertools.combinations(s, r) for r in range(len(s)+1))

#union-find
class uf:
	def __init__(self, n):
		self.ids = [i for i in range(n)]
	
	def find(self, u):
		if self.ids[u] == u:
			return u
		self.ids[u] = self.find(self.ids[u])
		return self.ids[u]

	def merge(self, u, v):
		if self.find(u) == self.find(v):
			return
		self.ids[self.find(u)] = self.find(v)

#input
n = int(raw_input())
gdp = [float(x) for x in raw_input().split()]
pop = [float(x) for x in raw_input().split()]
edges = []
for i in range(n-1):
	edges.append( [int(x)-1 for x in raw_input().split()] )

combinations = powerset( [i for i in range(n)] )
best = 0.
for iterable in combinations:
	for combination in list(iterable):
		if len(combination) == 0:
			continue
		tot_gdp = 0
		tot_pop = 0
		for i in combination:
			tot_gdp += gdp[i]
			tot_pop += pop[i]
		forest = uf(n)
		for edge in edges:
			u, v = edge
			if u in combination and v in combination:
				forest.merge(u, v)
		component = forest.find(0)
		connected = True
		for u in combination:
			if forest.find(u) != component:
				connected = False
		if not connected:
			continue
		#print combination, tot_gdp / tot_pop 
		best = max(best, tot_gdp / tot_pop)
print best
