#!/usr/bin/env python3
import math
EPS = 1e-6

k, w, l = [int(x) for x in input().split()]
w, l = float(w), float(l)

# Given alpha value, find when throw hits center after k bounces
def getDist(alpha):
    alpha = math.radians(alpha)
    global k, w
    d = 0
    adjacent = w / 2.0
    for _ in range(k): 
        # Recall math: opposite/adjacent = tan(alpha)
        d += math.tan(alpha) * adjacent
        alpha = math.atan(2 * math.tan(alpha))
        d += math.tan(alpha) * adjacent
    
    return d
    
# Binary search for answer
lo = 0.0
hi = 90.0
while lo + EPS < hi:
    mid = (lo + hi) / 2.0
    if getDist(mid) > l:
        hi = mid
    else:
        lo = mid

print(lo)