#!/usr/bin/env python3
import math

MAXSPEED = 180 #km per hour
EPS = 1e-12

def distSq(a, b):
    return (a[0] - b[0])**2 + (a[1] - b[1])**2
    
def getAngle(a, b, c):
    ## Pretend b is in origo. Now find angle ab, subtract angle bc.
    ## We are interested in 180 - this angle.
    ang_ab = math.atan2(a[1] - b[1], a[0] - b[0])
    ang_bc = math.atan2(c[1] - b[1], c[0] - b[0])
    ang = 180 - math.degrees(ang_ab - ang_bc)
    while (ang > 180):  ang -= 360
    while (ang < -180): ang += 360
    return ang
    
def almostEqual(a, b):
    return abs(a - b) < EPS

# print(getAngle((0, 0), (1,0), (0,0))) ## Expect 0
# print(getAngle((1, 1),(2, 1),(2, 2))) ## Expect 90
# print(getAngle((1, 1),(2, 1),(2, 0))) ## Expect -90#
# print(getAngle((1, 1),(2, 1),(1, 2))) ## Expect 135
# print(getAngle((0, 0),(1, 0),(2, 1))) ## Expect 45
# print(getAngle((1, 1),(2, 1),(1, 0))) ## Expect -135
# print(getAngle((1, 0),(2, 1),(1, 1))) ## Expect 135
# print(getAngle((1, 2),(2, 1),(1, 1))) ## Expect -135
    
n, k = [int(x) for x in input().split()]
road = [tuple(float(x) for x in input().split()) for _ in range(n)]

lengths = [distSq(road[i], road[i-1])**0.5 for i in range(1, n)]
rundist = [0]
for d in lengths:
    rundist.append(rundist[-1] + d)

angles = [0] + [abs(getAngle(road[i-1], road[i], road[i+1])) for i in range(1, n - 1)] + [0]

# Define dp[i][k'][c] = minimum time to get to i,
# having used <= k' signs. for c == 1, then also around corner,
dp = [[[float('inf'), float('inf')] for kp in range(k + 1)] for i in range(n)]

# Base case: when i=0, then always possible to travel here in 0 hours
for kp in range(k + 1):
    dp[0][kp][0] = 0
    dp[0][kp][1] = 0
# Base case, when k'=0, then it is possible only if all angles are 0.
for i in range(1, n):
    dp[i][0][0] = dp[i-1][0][1] + lengths[i-1]/MAXSPEED
    if almostEqual(0, angles[i]):
        dp[i][0][1] = dp[i][0][0]
    else:
        break
        
# Recursive case: dp[i][k']
for i in range(1, n):
    for kp in range(1, k + 1):
        
        # Get here not including this corner; guess previous sign location
        dp[i][kp][0] = dp[i][kp-1][0]
        maxangle = 0
        for j in range(i-1, -1, -1):
            ## Put up sign right after j to increase speed
            dp[i][kp][0] = min(dp[i][kp][0], dp[j][kp-1][1] + (rundist[i] - rundist[j])/(MAXSPEED-maxangle))
            maxangle = max(maxangle, angles[j])
            ## Put up sign right before j to decrease speed
            dp[i][kp][0] = min(dp[i][kp][0], dp[j][kp-1][0] + (rundist[i] - rundist[j])/(MAXSPEED-maxangle))
            
        ## Get here including this corner; guess previous sign location
        dp[i][kp][1] = min(dp[i][kp-1][1], dp[i][kp-1][0])
        maxangle = angles[i]
        for j in range(i-1, -1, -1):
            ## Put up sign right after j to increase speed
            dp[i][kp][1] = min(dp[i][kp][0], dp[j][kp-1][1] + (rundist[i] - rundist[j])/(MAXSPEED-maxangle))
            maxangle = max(maxangle, angles[j])
            ## Put up sign right before j to decrease speed
            dp[i][kp][1] = min(dp[i][kp][0], dp[j][kp-1][0] + (rundist[i] - rundist[j])/(MAXSPEED-maxangle))
                  
print(dp[n-1][k][0])
            
            