#!/usr/bin/env python3
import sys, argparse, random

parser = argparse.ArgumentParser(description="Generator for alehouse.")    
parser.add_argument('-n', metavar='N', type=int, required=True,
                    help='number of residents')
parser.add_argument('-k', metavar='K', type=int, default=None,
                    help='duration of stay')
parser.add_argument('-o', metavar='O', type=str, default="random",
                    help='options')
parser.add_argument('-s', metavar='S', type=int, default=None,
                    help='seed')
args = parser.parse_args()
random.seed(args.s)

MAXTIME = 604800000

n = args.n
k = args.k
options = args.o



if "smallrange" in options:
    MAXTIME = min(4*n, MAXTIME)
    
if k is None:
    k = random.randrange(MAXTIME // 10)

people = []


if "nooverlap" in options:
    nums = sorted(random.sample(range(MAXTIME), 2*n), key=lambda x: -x)
    for _ in range(n):
        a, b = nums.pop(), nums.pop()
        people.append((a, b))
        
elif "samedur" in options:
    for _ in range(n):
        a = random.randrange(MAXTIME - k)
        people.append((a, a+k))
        
elif "peak" in options:
    cubert = int(n**0.25)
    
    nums = sorted(random.sample(range(MAXTIME), 2*(n-cubert)), key=lambda x: -x)
    for _ in range(n-cubert):
        a, b = nums.pop(), nums.pop()
        people.append((a, b))
        
    a = random.randrange(MAXTIME)
    for _ in range(cubert):
        people.append((a, a))
    
else:
    for _ in range(n):
        a, b = random.randrange(MAXTIME), random.randrange(MAXTIME)
        people.append((min(a, b), max(a, b)))



print(n, k)
random.shuffle(people)
for a, b in people:
    print(a, b)
