package solution;

import java.util.*;

public class Hypotenuse {
    public static void main (String[] args) {
        Scanner sc = new Scanner(System.in);
        String a = sc.next();
        String b = sc.next();
        String c = sc.next();

        if (a.equals("?")) {
            solve1(Integer.parseInt(b), Integer.parseInt(c));
        } else if (b.equals("?")) {
            solve1(Integer.parseInt(a), Integer.parseInt(c));
        } else {
            solve2(Integer.parseInt(a), Integer.parseInt(b));
        }
    }

    private static void solve1(int a, int c) {
        int b_squared = c * c - a * a;
        sqrtLatex(b_squared);
    }

    private static void solve2(int a, int b) {
        int c_squared = a * a + b * b;
        sqrtLatex(c_squared);
    }

    private static void sqrtLatex(int n) {
        int root = n;
        int factor = 1;

        int i = 2;
        while (i * i <= root) {
            if(root % (i * i) == 0) {
                root /= i * i;
                factor *= i;
            } else {
                i++;
            }
        }

        if (root == 1) {
            System.out.println(factor);
        } else if (factor == 1) {
            System.out.println("\\sqrt{" + root + "}");
        } else {
            System.out.println(factor + " \\cdot \\sqrt{" + root + "}");
        }
    }
}
