import java.util.*;

public class C {
	public static int[] parent, size;

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		int n = sc.nextInt();
		int e = sc.nextInt();
		
		parent = new int[n+1];
		for(int i=0;i<=n;i++) parent[i] = i;
		size = new int[n+1];
		
		int primes = 0;
		for(int i=0;i<e;i++){
			int a = sc.nextInt();
			int b = sc.nextInt();
			int w = sc.nextInt();
			if(isPrime(w)){
				if(find(a) != find(b)){
					merge(a,b);
					primes++;
				}
			}
		}
		System.out.println(primes+" "+(n-primes-1));
	}
	
	public static int find(int n){
		if(parent[n] == n) return n;
		return parent[n] = find(parent[n]);
	}
	
	public static void merge(int x, int y){
		int rx = find(x);
		int ry = find(y);
		if(rx == ry) return;
		size[ry] += size[rx];
		parent[rx] = parent[ry];
	}

	public static boolean isPrime(int n){
		if(n <= 1) return false;
		if(n == 2) return true;
		if(n%2 == 0) return false;
		for(int i=3;i*i<=n;i+=2){
			if(n%i==0) return false;
		}
		return true;
	}
}
