import java.util.*;
public class LibraryAdministration {
	static boolean CORRUPT = false;
	static Stack<String> pile = new Stack<String>();
	static Set<String> pbooks = new HashSet<String>();

	public static class User {
		String name;
		Map<String, Integer> books;
		int pay = 0;
		
		public User(String name) {
			this.name = name;
			books = new HashMap<String, Integer>();
		}
		
		public String getPay() {
			pay += books.size() * 1000;
			if (pay % 100 >= 10) {
				return "E" + (pay / 100) + "" + (pay % 100);
			} else {
				return "E" + (pay / 100) + ".0" + (pay % 100);
			}
		}
		
		public void returnBook(String title, int day) {
			if (books.containsKey(title)) {
				int start = books.remove(title);
				if(day - start - 3 > 0)
					pay += 23 * (day - start - 3);
				pile.add(title);
			} else {
				CORRUPT = true;
			}
		}
		
		public void addBook(String title, int day) {
			if (pbooks.contains(title)) {
				CORRUPT = true;
			} else {
				books.put(title, day);
				pbooks.add(title);
			}
		}
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		int loglines = sc.nextInt();
		Map<String, User> users = new TreeMap<String, User>();

		for (int i = 0; i < loglines && !CORRUPT; i++) {
			int t = sc.nextInt();
			sc.next();
			String a = sc.next();
			if (a.matches("[0-9]+")) {
				int n = Integer.parseInt(a);
				sc.next();
				sc.next();
				sc.next();
				if(pile.size()<n){
					System.out.println("CORRUPT");
					return;
				}
				for (int k = 0; k < n; k++) {
					String title = pile.pop();
					pbooks.remove(title);
				}
			} else {
				String username = a;
				String type = sc.next();
				String title = sc.next();
				if (!users.containsKey(username)) {
					users.put(username, new User(username));
				}
				User user = users.get(username);
				if (type.equals("borrows")) {
					user.addBook(title, t);
				} else { // returns
					user.returnBook(title, t);
				}
			}
		}

		if (CORRUPT) {
			System.out.println("CORRUPT");
		} else {
			Set<String> set = users.keySet();
			for (String s : set) {
				System.out.println(s + " " + users.get(s).getPay());
			}
		}
	}

}
