package problems.friends;

import java.util.Arrays;
import java.util.Random;
import java.util.Scanner;

public class ChrSolution {
	static class UF{
		Random r;
		int[] ids = new int[50000];
		
		public UF(){
			Arrays.fill(ids, -1);
			r = new Random();
		}
		public int find(int x){
			if(ids[x] == -1) throw new Error();
			if(ids[x] == x) return x;
			return ids[x] = find(ids[x]);
		}
		
		public void union(int a, int b){
			if(r.nextBoolean()){
				ids[find(a)] = find(b);
			} else{
				ids[find(b)] = find(a);
			}
		}
		
		public void make(int x){
			ids[x] = x;
		}
		
		public String toString(){
			return Arrays.toString(Arrays.copyOfRange(ids, 0, 100));
		}
	}
	
	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		int n = sc.nextInt();
		int m = sc.nextInt();
		int s = sc.nextInt();
		UF u = new UF();
		for(int i = 0; i < n;i++){
			u.make(i);
		}
		for(int i = 0; i < m;i++){
			int a = sc.nextInt();
			int b = sc.nextInt();
			u.union(a, b);
		}
		boolean connected = true;
		s = u.find(s);
		for(int i = 0; i < n && connected;i++){
			if(s != u.find(i)){
				connected = false;
			}
		}
		System.out.println(connected ? "yes" : "no");
	}
}
