DIRS = [(-1, 0), (1, 0), (0, 1), (0, -1)]

h, w = [int(x) for x in input().split()]
grid = [input().strip() for _ in range(h)]

valid = {(x, y) for y, row in enumerate(grid) for x, c in enumerate(row) if c == "D"}
todo = {(x + dx, y + dy) for x, y in valid for dx, dy in DIRS
        if grid[y + dy][x + dx] == "." and (x + dx, y + dy) not in valid}

while todo:
    x, y = todo.pop()
    for dx, dy in DIRS:
        if (x - dx, y - dy) in valid and grid[y + dy][x + dx] != "#":
            valid.add((x, y))
            todo.update({(x + dx, y + dy) for dx, dy in DIRS
                         if grid[y + dy][x + dx] == "." and (x + dx, y + dy) not in valid})

print(*("".join("O" if (x, y) in valid else "X" for x in range(w)) for y in range(h)), sep="\n")
