n = int(input())
code1 = [input().split() for _ in range(n)]
code2 = [input().split() for _ in range(n)]

if any(len(line1) != len(line2) for line1, line2 in zip(code1, code2)):
    # If some lines have different lengths, it's not fraud
    print(-1)
    exit()

mapper1 = dict()
mapper2 = dict()
for line1, line2 in zip(code1, code2):
    for word1, word2 in zip(line1, line2):
        if word1 in mapper1 and mapper1[word1] != word2:
            # If we already have a mapping for word1 but word2 is different, it's not fraud
            print(-1)
            exit()
        if word2 in mapper2 and mapper2[word2] != word1:
            # If we already have a mapping for word2 but word1 is different, it's not fraud
            print(-1)
            exit()
        mapper1[word1] = word2
        mapper2[word2] = word1

mapper1 = {word1: word2 for word1, word2 in mapper1.items() if word1 != word2}  # Only print non-equal mapped words
print(len(mapper1), *sorted(f"{word1} {word2}" for word1, word2 in mapper1.items()), sep="\n")
