#!/usr/bin/env python3

[n, m] = [int(i) for i in input().split()]
edges = [set() for _ in range(n + 1)]
for _ in range(m):
    [a, b] = [int(i) for i in input().split()]
    edges[a].add(b)
    edges[b].add(a)

# Remove "tails" from the graph, so that the graph only exists of cycles
singletons = {i for i in range(1, n + 1) if len(edges[i]) == 1}
while singletons:
    current = singletons.pop()
    if not edges[current]:
        continue
    neighbour: int = edges[current].pop()
    edges[neighbour].remove(current)
    if len(edges[neighbour]) == 1:
        singletons.add(neighbour)

# Count number of edges; if there is an even number of edges, print 2; else, print 3
print(2 if sum(len(e) for e in edges) % 4 == 0 else 3)
