import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class HaltAndCatchFire {

    public static class OpLine {
        String op;
        String argA;
        String argB;

        OpLine(String op, String argA, String argB) {
            this.op = op;
            this.argA = argA;
            this.argB = argB;
        }


        @Override
        public String toString() {
            return op + " " + argA + " " + argB;
        }
    }

    public static void main(String[] args) {
        Scanner input = new Scanner(System.in);
        int lines = Integer.parseInt(input.nextLine());

        ArrayList<String> program = new ArrayList<>();
        for(int i = 0; i<lines; i++) {
            program.add(input.nextLine());
        }

        runProgram(program);
    }

    private static void runProgram(ArrayList<String> program) {
        int debug = -1;

        HashMap<String, Integer> env = new HashMap<>();

        env.put("out", 0);
        env.put("acc", 0);
        env.put("pc", 0);
        env.put("cmp", 0);
        while(env.get("pc") < program.size() && env.get("pc") >= 0) {
            OpLine opLine = parseLine(program.get(env.get("pc")));

            switch (opLine.op) {
                case "mov":
                    env.put(opLine.argB.substring(1),parseArg(opLine.argA, env));
                    break;
                case "add":
                    opAddSub(opLine.argA, opLine.argB, env, false);
                    break;
                case "sub":
                    opAddSub(opLine.argA, opLine.argB, env, true);
                    break;
                case "jeq":
                    if(parseArg(opLine.argA, env).equals(env.get("cmp"))) {
                        env.put("pc", parseArg(opLine.argB, env)-1);
                    }
                    break;
                case "hcf":
                    debug = env.get("pc");
                    env.put("pc", -999);
                    break;
                default:
                    break;
            }
            env.put("pc", env.get("pc") + 1);
        }

        if(debug != -1) {
            System.out.println(program.get(debug));
            System.out.println(env.get("acc"));
            System.out.println(env.get("cmp"));
            System.out.println(env.get("out"));
        } else {
            System.out.println(env.get("out"));
        }
    }

    private static OpLine parseLine(String line) {
        String op = line.subSequence(0,3).toString();
        String[] args = line.split(" ");
        return new OpLine(args[0],args[1],args[2]);
    }

    private static Integer parseArg(String arg, HashMap<String, Integer> env) {
        if(arg.contains("$")) {
            return env.get(arg.substring(1));
        } else {
            return Integer.parseInt(arg);
        }
    }

    private static void opAddSub(String argA, String argB, HashMap<String, Integer> env, Boolean sub) {
        if(sub) {
            env.put("acc", parseArg(argA, env) - parseArg(argB, env));
        } else {
            env.put("acc", parseArg(argA, env) + parseArg(argB, env));
        }
    }
}
