import java.io.*;
import java.util.*;

public class BitSetWithHeuristics_OffByOne {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new BitSetWithHeuristics_OffByOne().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        int n = sc.nextInt(), m = sc.nextInt();
        int[] buttons = new int[m];
        for (int i = 0; i < m; i++) {
            buttons[i] = sc.nextInt();
        }
        Arrays.sort(buttons);

        // Shortcut: if there is only one button, then we don't even need to do any fancy calculations
        if (m == 1) {
            if (buttons[0] == 1)
                System.out.println(n - 1); // Hard-coding the second sample test
            else
                System.out.println(n / buttons[0]); // WRONG: Should be (n - 1) / buttons[0]
            return;
        }

        // Observation: if the GCD of all buttons is > 1, then there are many timestamps that can never be reached.
        // Example: if the GCD is 2, then all odd seconds cannot be reached.
        // Example: if the GCD is 5, then all timestamps not divisible by 5 cannot be reached.
        // Simplification: divide all buttons and the length of the movie (n) by this common factor.
        int factor = gcd(buttons[0], buttons[1]);
        for (int i = 2; i < m; i++) {
            factor = gcd(factor, buttons[i]);
        }
        n /= factor;
        for (int i = 0; i < m; i++) {
            buttons[i] /= factor;
        }

        // Observation: the buttons are never larger than 1000, so all timestamps > 10^6 can always be reached.
        // Simplification: Only do the brute-force calculations on numbers smaller than 10^6,
        //     while saving how many of the "extra" seconds above 10^6 we can always reach.
        int extra = Math.max(0, n - 1_000_000);
        n = Math.min(n, 1_000_000);

        // After that, we do the same brute-force calculation as "BitSetNaive"
        BitSet reachable = new BitSet(n + 1);
        for (int button : buttons) {
            if (reachable.cardinality() < n / 2) {
                int i = 0;
                while (i != -1 && i + button < n) {
                    reachable.set(i + button);
                    i = reachable.nextSetBit(i + 1);
                }
            } else {
                reachable.set(button);
                int i = button;
                while (i < n) {
                    if (reachable.get(i - button))
                        reachable.set(i);
                    i = reachable.nextClearBit(i + 1);
                }
            }
        }
        System.out.println(reachable.cardinality() + extra);
    }

    public int gcd(int a, int b) {
        while (b > 0) {
            int r = a % b;
            a = b;
            b = r;
        }
        return a;
    }
}
