import java.io.*;
import java.util.*;

public class BitSetUsingZeroes {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new BitSetUsingZeroes().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        int n = sc.nextInt(), m = sc.nextInt();
        int[] buttons = new int[m];
        for (int i = 0; i < m; i++) {
            buttons[i] = sc.nextInt();
        }
        Arrays.sort(buttons);
        BitSet reachable = new BitSet(n + 1);
        for (int button : buttons) {
            if (reachable.cardinality() < n / 2) { // If the BitSet contains more 1s than 0s, iterate over the 1s
                int i = 0;
                while (i != -1 && i + button < n) {
                    reachable.set(i + button);
                    i = reachable.nextSetBit(i + 1);
                }
            } else { // If the BitSet contains more 0s than 1s, iterate over the 0s
                reachable.set(button);
                int i = button;
                while (i < n) {
                    if (reachable.get(i - button))
                        reachable.set(i);
                    i = reachable.nextClearBit(i + 1);
                }
            }
        }
        System.out.println(reachable.cardinality());
    }
}
