//
// Created by Dragos Paul Vecerdea on 09/06/2020.
//
#include <iostream>
#include <vector>
#include <queue>
#include <climits>
using namespace std;

long long maxAll = LLONG_MIN;

struct Node {
    long long value;
    int childrenSize;
    vector<Node> children;
};

long long maximum(long long a, long long b) {
    if(a < b) return b;
    return a;
}

Node read() {
    Node newNode;
    cin >> newNode.value;
    cin >> newNode.childrenSize;
    for(int i = 0; i < newNode.childrenSize; i++) {
        newNode.children.push_back(read());
    }
    return newNode;
}

long long findMax(Node currentRoot) {
    priority_queue<long long, std::vector<long long>, std::greater<long long>> bestTwo;
    for(Node child : currentRoot.children) {
        bestTwo.push(findMax(child));
        while(bestTwo.size() > 2) {
            bestTwo.pop();
        }
    }

    long long max2 = bestTwo.size() > 0 ? maximum(0,bestTwo.top()) : 0;
    if(bestTwo.size() > 0) bestTwo.pop();
    long long max1 = bestTwo.size() > 0 ? maximum(0,bestTwo.top()) : 0;


    if(max1 + max2 + currentRoot.value > maxAll) {
        maxAll = max1 + max2 + currentRoot.value;
    }

    return maximum(max1,max2) + currentRoot.value;

}
int main() {
    int n;
    cin >> n;
    findMax(read());
    cout << maxAll;
}
