import java.util.*;
import java.io.*;

public class RecursiveSolution {

    private long max = Long.MIN_VALUE;

    static class Tree {
        int value;
        List<Tree> children;

        Tree(int value) {
            this.value = value;
            this.children = new ArrayList<>();
        }
    }

    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        RecursiveSolution sol = new RecursiveSolution();
        sol.solve(sc);
        sc.close();
    }

     public Tree readTree(Scanner sc) {
        int val = sc.nextInt();
        int nbChildren = sc.nextInt();
        Tree current = new Tree(val);
        for(int i=0; i<nbChildren; i++) {
            current.children.add(readTree(sc));
        }
        return current;
    }

    public long solve(Scanner sc) {
        sc.nextInt();
        Tree t = readTree(sc);
        maxSum(t);
        System.out.println(max);
        return max;
    }

    /**
     * Calculates the maximum sum for all paths in a tree
     * with the condition that the path either starts or ends with the root value
     * Note that the path only follows either only child -> parent relations or parent->child relations
     * @param root The root of the tree
     * @return Value of the sum with the conditions
     */
    public long maxSum(Tree root) {
        int val = root.value;
        long max1 = Long.MIN_VALUE;
        long max2 = Long.MIN_VALUE;
        for(Tree t : root.children) {
            long sum = maxSum(t);
            if (sum > max1) {
                max2 = max1;
                max1 = sum;
            } else if (sum > max2) {
                max2 = sum;
            }
        }

        max1 = Math.max(max1, 0);
        max2 = Math.max(max2, 0);

        max = Math.max(val + max1 + max2, max);

        return val + Math.max(max1, max2);
    }

}
