#!/usr/bin/env python3
# Solution by team Crystal Math (1st place).
# Solution submitted after 171 minutes.

class V:
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

    def cross(self, other):
        return V(self.y*other.z - self.z*other.y, self.z*other.x-self.x*other.z, self.x*other.y-self.y*other.x)

    def inner(self, other):
        return self.x * other.x + self.y * other.y + self.z * other.z
    def __add__(self, other):
        return V(self.x+other.x, self.y+other.y, self.z + other.z)
    def __mul__(self, other):
        return V(self.x*other, self.y*other, self.z*other)
    def __rmul__(self, other):
        return self * other
    def __abs__(self):
        return (self.x**2 + self.y**2 + self.z**2)**0.5
    def __repr__(self):
        return "{}, {}, {}".format(self.x, self.y, self.z)


m = int(input())
v = V(*map(float, input().split()))
h = V(*map(float, input().split()))
p = []
d = []


for _ in range(m):
    p1, p2, p3, d1, d2, d3 = map(float, input().split())
    p.append(V(p1, p2, p3))
    d.append(V(d1, d2, d3))

n = v.cross(h)
count = 0
for x, y in zip(p, d):
    try:
        labda = -1*n.inner(x) / n.inner(y)
    except ZeroDivisionError:
        continue
    if labda < 0:
        continue
    s = x + labda * y
    alpha = abs(s.inner(v))/abs(v)**2
    beta = abs(s.inner(h))/abs(h)**2
    if alpha**2 + beta**2 <= 1.0:
        count += 1
print(count)

'''
3
2.0 0.0 0.0
0.0 1.0 0.0
0.0 0.0 2.0 2.0 1.0 4.0
0.0 0.0 -2.0 2.0 1.0 4.0
0.0 0.0 2.0 2.0 0.0 0.0

6
1.0 1.0 0.0
1.0 -1.0 1.0
0.0 0.0 1.0 0.0 0.0 -1.0
0.0 0.0 1.0 1.0 1.0 0.0
0.0 0.0 1.0 1.0 -1.0 1.0
1.0 -1.0 -1.0 -1.0 1.0 8.0
1.0 -1.0 -1.0 1.0 -1.0 8.0
-1.0 1.0 1.0 1.0 -1.0 -8.0
'''
