import java.io.FileWriter;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

public class GenerateGraphs {

    static Random random = new Random(424242);

    static int[][] problems = {
            // n, m, s, path length
            {10, 30, 7, 5},
            {1000, 3000, 500, 300},
            {10_000, 1_000_000, 5_000, 1000},
            {100_000, 1_000_000, 100_000, 10_000},
    };

    public static void main(String[] args) throws IOException {
        for (int[] problem : problems) {
            String graph = generateGraph(problem);
            List<Integer> answer = new H_Correct().calculatePath(new Scanner(graph));
            FileWriter file = new FileWriter("../data/secret/" + problemName(problem) + ".in");
            file.write(graph);
            file.close();
            file = new FileWriter("../data/secret/" + problemName(problem) + ".ans");
            file.write(answer.size() + "\n");
            file.close();
        }
    }

    private static String generateGraph(int[] problem) {
        int n = problem[0], m = problem[1], s = problem[2], p = problem[3];
        List<Integer> intersections = new ArrayList<>(n);
        for (int i = 2; i < n; i++) {
            intersections.add(i);
        }
        Collections.shuffle(intersections, random);

        List<Integer> path = new ArrayList<>(p);
        path.add(1);
        path.addAll(intersections.subList(0, p - 2));
        path.add(n);

        List<Integer> shrooms = new ArrayList<>(s);
        shrooms.addAll(path);
        shrooms.addAll(intersections.subList(n - 2 - s + p, n - 2));
        Collections.sort(shrooms);

        intersections.add(1);
        intersections.add(n);
        Collections.shuffle(intersections, random);
        Set<String> edges = new HashSet<>(m);
        for (int i = 0; i < p - 1; i++) {
            edges.add(path.get(i) + " " + path.get(i + 1));
        }
        int i = 0;
        while (edges.size() < m) {
            i++;
            if (i >= n - 1) {
                i = 0;
                Collections.shuffle(intersections, random);
            }
            edges.add(intersections.get(i) + " " + intersections.get(i + 1));
        }

        StringBuilder sb = new StringBuilder();
        sb.append(n).append(' ').append(m).append(' ').append(s).append('\n');
        sb.append(shrooms.stream().map(a -> "" + a).skip(1).limit(s - 2).collect(Collectors.joining(" "))).append('\n');
        for (String edge : edges) {
            sb.append(edge).append("\n");
        }
        return sb.toString();
    }

    private static String problemName(int[] problem) {
        return "n_" + problem[0] + "_m_" + problem[1] + "_s_" + problem[2] + "_p_" + problem[3];
    }
}
