import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;

public class E_CountPrimesSlow {
    public static void main(String[] args) throws IOException {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new E_CountPrimesSlow().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        long n = sc.nextLong();
        System.out.println(countPrimesSlow(n));
    }

    /**
     * For every number i between 2 and n, count the number of times that i can be divided by 5.
     * Complexity: O(n log n)
     */
    private long countPrimesSlow(long n) {
        long fives = 0;
        for (; n > 1; n--) {
            long i = n;
            while (i % 5 == 0) {
                i /= 5;
                fives++;
            }
        }
        return fives;
    }
}
