import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

import static java.util.stream.IntStream.range;

public class B_timeout {
    public static void main(String[] args) throws IOException {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new B_timeout().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        int n = sc.nextInt(), m = sc.nextInt();
        String[][] grid = new String[n][n];
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                grid[i][j] = sc.next();
            }
        }
        String[] events = new String[m];
        for (int i = 0; i < m; i++) {
            events[i] = sc.next();
        }
        System.out.println(calculateBingo(n, m, grid, events));
    }

    public String calculateBingo(int n, int m, String[][] grid, String[] events) {
        if (n == 1) return "0";
        boolean[][] crossed = new boolean[n][n];
        Map<String, Pos> map = new HashMap<>(n * n);
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                map.put(grid[i][j], new Pos(i, j));
            }
        }
        crossed[n / 2][n / 2] = true; // Free lunch!
        for (int i = 0; i < m; i++) {
            Pos pos = map.get(events[i]);
            if (pos == null) continue;
            crossed[pos.x][pos.y] = true;
            if (range(0, n).anyMatch(j -> range(0, n).allMatch(k -> crossed[j][k])))
                return i + 1 + "";
            if (range(0, n).anyMatch(j -> range(0, n).allMatch(k -> crossed[k][j])))
                return i + 1 + "";
            if (range(0, n).allMatch(k -> crossed[k][k]))
                return i + 1 + "";
            if (range(0, n).allMatch(k -> crossed[k][n - k - 1]))
                return i + 1 + "";
        }
        return ":-(";
    }

    public static class Pos {
        int x, y;

        public Pos(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}
