/*
 * @EXPECTED_RESULTS@: CORRECT
 */
using System;

public class jeroen
{
	public static int N;
	public static int[] M;
	public static Point[][] pt;

	public static void Main(string[] args)
	{
		// Let C# always use '.' for outputting doubles
		System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.InvariantCulture;

		int tests = int.Parse(Console.ReadLine());
		while(tests-- > 0)
		{
			N = int.Parse(Console.ReadLine());
			string[] p = Console.ReadLine().Split();
			int S = int.Parse(p[0]);
			int D = int.Parse(p[1]);
			M = new int[N];
			pt = new Point[N][];
			for(int i = 0; i < N; i++)
			{
				M[i] = int.Parse(Console.ReadLine());
				pt[i] = new Point[M[i]];
				for(int j = 0; j < M[i]; j++)
					pt[i][j] = new Point(Console.ReadLine());
			}

			double[,] dist = new double[N,N];
			for(int i = 0; i < N; i++)
				for(int j = i + 1; j < N; j++)
					dist[i,j] = dist[j,i] = PolyDist(i, j);
			for(int i = 0; i < N; i++)
				for(int j = 0; j < N; j++)
					for(int k = 0; k < N; k++)
						dist[j,k] = Math.Min(dist[j,k], dist[j,i] + dist[i,k]);
			Console.WriteLine("{0:0.000}", dist[S-1,D-1]);
		}
	}

	public static double PolyDist(int i, int j)
	{
		double res = double.MaxValue;
		for(int g = 0; g < M[i]; g++)
		{
			for(int h = 0; h < M[j]; h++)
			{
				res = Math.Min(res, LinePointDist(pt[i][g], pt[i][(g+1)%M[i]], pt[j][h], true));
				res = Math.Min(res, LinePointDist(pt[j][h], pt[j][(h+1)%M[j]], pt[i][g], true));
			}
		}
		return res;
	}

	public class Point
	{
		public int X, Y;

		public Point(string s)
		{
			string[] p = s.Split();
			X = int.Parse(p[0]);
			Y = int.Parse(p[1]);
		}
	}

	public static double Distance(Point A, Point B)
	{
		return Math.Sqrt((A.X - B.X) * (A.X - B.X) + (A.Y - B.Y) * (A.Y - B.Y));
	}

	/* Distance from line L1-L2 to P
	 * If isSegment, the line is taken as a segment */
	public static double LinePointDist(Point L1, Point L2, Point P, bool isSegment)
	{
		if (isSegment)
		{
			if ((P.X - L2.X) * (L2.X - L1.X) + (P.Y - L2.Y) * (L2.Y - L1.Y) > 0) return Distance(L2, P);
			if ((P.X - L1.X) * (L1.X - L2.X) + (P.Y - L1.Y) * (L1.Y - L2.Y) > 0) return Distance(L1, P);
		}
		return Math.Abs(((L2.X - L1.X) * (P.Y - L1.Y) - (L2.Y - L1.Y) * (P.X - L1.X)) / Distance(L1, L2));
	}
}
