/*
 * @EXPECTED_RESULTS@: CORRECT
 */
import java.io.*;
import java.util.*;

public class jeroen2
{
	final static int TOP = 0;
	final static int FRONT = 1;
	final static int LEFT = 2;
	final static int BOTTOM = 3;
	final static int BACK = 4;
	final static int RIGHT = 5;
	
	public static void main(String[] args)
	{
		Scanner sc = new Scanner(System.in);
		int tests = sc.nextInt();
		while (tests-- > 0)
		{
			Cube c = new Cube();
			int N = sc.nextInt();
			String[] moves = new String[N];
			for(int i = 0; i < N; i++)
				moves[i] = sc.next();
			for(int i = 0; i < N; i++)
			{
				switch (moves[i].charAt(0))
				{
				case 'F':
					c.Front(moves[i].charAt(1) == '+');
					break; 
				case 'R':
					c.MoveRight();
					c.Front(moves[i].charAt(1) == '+');
					c.MoveRight();
					c.MoveRight();
					c.MoveRight();
					break; 
				case 'B':
					c.MoveRight();
					c.MoveRight();
					c.Front(moves[i].charAt(1) == '+');
					c.MoveRight();
					c.MoveRight();
					break; 
				case 'L':
					c.MoveRight();
					c.MoveRight();
					c.MoveRight();
					c.Front(moves[i].charAt(1) == '+');
					c.MoveRight();
					break; 
				case 'U':
					c.MoveTop();
					c.Front(moves[i].charAt(1) == '+');
					c.MoveTop();
					c.MoveTop();
					c.MoveTop();
					break; 
				case 'D':
					c.MoveTop();
					c.MoveTop();
					c.MoveTop();
					c.Front(moves[i].charAt(1) == '+');
					c.MoveTop();
					break;
				}
			}
			c.PrintSide(TOP);
		}
	}

	private static class Cube
	{
		private char[][] sides;

		public Cube()
		{
			sides = new char[6][9];

			SetSide(TOP, 'w');
			SetSide(FRONT, 'r');
			SetSide(LEFT, 'g');
			SetSide(BOTTOM, 'y');
			SetSide(BACK, 'o');
			SetSide(RIGHT, 'b');
		}

		private void SetSide(int s, char c)
		{
			for(int i = 0; i < 9; i++)
				sides[s][i] = c;
		}

		public void PrintSide(int s)
		{
			for(int i = 0; i < 3; i++)
			{
				for(int j = 0; j < 3; j++)
					System.out.print(sides[s][i*3+j]);
				System.out.println();
			}
		}

		public void Front(boolean clockwise)
		{
			if(clockwise) FrontClockwise();
			else FrontCounterClockwise();
		}

		public void FrontClockwise()
		{
			// First rotate the face itself
			RotateFace(FRONT);

			// Now rotate the rest of the parts
			char[][] nsides = new char[6][9];
			for(int i = 0; i < 6; i++)
				for(int j = 0; j < 9; j++)
					nsides[i][j] = sides[i][j];

			/*0 1 2
			 *3 4 5
			 *6 7 8
			 */
			// Top row
			nsides[TOP][6] = sides[LEFT][8];
			nsides[TOP][7] = sides[LEFT][5];
			nsides[TOP][8] = sides[LEFT][2];

			// Right side
			nsides[RIGHT][0] = sides[TOP][6];
			nsides[RIGHT][3] = sides[TOP][7];
			nsides[RIGHT][6] = sides[TOP][8];

			// Bottom
			nsides[BOTTOM][0] = sides[RIGHT][6];
			nsides[BOTTOM][1] = sides[RIGHT][3];
			nsides[BOTTOM][2] = sides[RIGHT][0];

			// Left
			nsides[LEFT][2] = sides[BOTTOM][0];
			nsides[LEFT][5] = sides[BOTTOM][1];
			nsides[LEFT][8] = sides[BOTTOM][2];

			sides = nsides;
		}

		public void FrontCounterClockwise()
		{
			FrontClockwise();
			FrontClockwise();
			FrontClockwise();
		}

		public void RotateFace(int s)
		{
			char[][] nsides = new char[6][9];
			for(int i = 0; i < 6; i++)
				for(int j = 0; j < 9; j++)
					nsides[i][j] = sides[i][j];

			// Corners
			nsides[s][2] = sides[s][0];
			nsides[s][8] = sides[s][2];
			nsides[s][6] = sides[s][8];
			nsides[s][0] = sides[s][6];

			// Middle parts
			nsides[s][5] = sides[s][1];
			nsides[s][7] = sides[s][5];
			nsides[s][3] = sides[s][7];
			nsides[s][1] = sides[s][3];

			sides = nsides;
		}

		public void MoveRight()
		{ // Move the cube such that you look at the right side
			RotateFace(TOP);
			RotateFace(BOTTOM);
			RotateFace(BOTTOM);
			RotateFace(BOTTOM);
			char[][] nsides = new char[6][9];
			for(int i = 0; i < 6; i++)
				for(int j = 0; j < 9; j++)
					nsides[i][j] = sides[i][j];
			nsides = CopyFace(nsides, RIGHT, FRONT);
			nsides = CopyFace(nsides, BACK, RIGHT);
			nsides = CopyFace(nsides, LEFT, BACK);
			nsides = CopyFace(nsides, FRONT, LEFT);
			sides = nsides;
		}

		private char[][] CopyFace(char[][] nsides, int s1, int s2)
		{
			for(int i = 0; i < 9; i++)
				nsides[s2][i] = sides[s1][i];
			return nsides;
		}

		public void MoveTop()
		{ // Move the cube such that you look at the top side
			RotateFace(LEFT);
			RotateFace(RIGHT);
			RotateFace(RIGHT);
			RotateFace(RIGHT);
			char[][] nsides = new char[6][9];
			for(int i = 0; i < 6; i++)
				for(int j = 0; j < 9; j++)
					nsides[i][j] = sides[i][j];
			nsides = CopyFace(nsides, TOP, FRONT);
			nsides = CopyFace(nsides, BACK, TOP);
			nsides = CopyFace(nsides, BOTTOM, BACK);
			nsides = CopyFace(nsides, FRONT, BOTTOM);
			sides = nsides;
			RotateFace(BACK);
			RotateFace(BACK);
			RotateFace(TOP);
			RotateFace(TOP);
		}
	}
}