from sys import stdout, exit, stderr
w, h = [int(x) for x in input().split()]
horizon_pts = []

# BS on LHS
left_hi = h
left_lo = 1
while left_hi - left_lo > 1:
    mid = (left_hi + left_lo)//2
    print("?", 1, mid)
    stdout.flush()
    answer = input()
    if answer == "horizon":
        left_hi = left_lo = mid
        horizon_pts.append([1, mid])
        break
    elif answer == "sea":
        left_lo = mid
    elif answer == "sky":
        left_hi = mid
    else:
        assert False

# BS on RHS
right_hi = h
right_lo = 1
while right_hi - right_lo > 1:
    mid = (right_hi + right_lo)//2
    print("?", w, mid)
    stdout.flush()
    answer = input()
    if answer == "horizon":
        right_hi = right_lo = mid
        horizon_pts.append([w, mid])
        break
    elif answer == "sea":
        right_lo = mid
    elif answer == "sky":
        right_hi = mid
    else:
        assert False

if len(horizon_pts) == 2:
    print("!", *horizon_pts[0], *horizon_pts[1])
    exit()

def below(x1, y1, x2, y2, x3, y3):
    """Assuming x1 < x2, does (x3, y3) lie below the line through ((x1, y1),
    (x2, y2))?"""
    return (y3 - y1)*(x2 - x1) < (x3 - x1)*(y2 - y1)

def above(x1, y1, x2, y2, x3, y3):
    return below(x2, y2, x1, y1, x3, y3)

remaining_points = []
for x in range(2, w):
    for y in range(2, h):
        if below(1, left_hi, w, right_hi, x, y) and \
                above(1, left_lo, w, right_lo, x, y):
            remaining_points.append((x, y))

# print("Remaining points:", remaining_points, file=stderr)

while len(horizon_pts) < 2:
    xq, yq = remaining_points[0]
    print("?", xq, yq)
    stdout.flush()
    answer = input()
    if answer == "horizon":
        horizon_pts.append((xq, yq))
        remaining_points = remaining_points[1:]
        # print("Remaining points:", remaining_points, file=stderr)
    elif answer == "sky":
        remaining_points = [(x, y) for x, y in remaining_points[1:] if 
                (1 < x < xq and below(1, left_hi, xq, yq, x, y)) or 
                (xq < x < w and below(xq, yq, w, right_hi, x, y))]
        # print("Remaining points:", remaining_points, file=stderr)
    elif answer == "sea":
        remaining_points = [(x, y) for x, y in remaining_points[1:] if 
                (1 < x < xq and above(1, left_lo, xq, yq, x, y)) or
                (xq < x < w and above(xq, yq, w, right_lo, x, y))]
        # print("Remaining points:", remaining_points, file=stderr)

print("!", *horizon_pts[0], *horizon_pts[1])
