#include "validation.h"

using namespace std;

constexpr int QUERIES = 900;

struct P {
	long long x, y;
};
long long dot(P p, P q) { return p.x * q.y - p.y * q.x; }
long long area(P p, P q, P r) { return dot(p, q) + dot(q, r) + dot(r, p); }

int main(int argc, char** argv) {
	std::ifstream in(argv[1]);
	OutputValidator v(argc, argv);

	int W, H;
	in >> W >> H;
	P p{}, q{};
	in >> p.x >> p.y >> q.x >> q.y;

	cout << W << ' ' << H << std::endl;

	int queries = 0;
	while(true) {
		string op = v.read_string("op", 1, 1, "?!");
		if(op == "?") {
			++queries;
			v.check(queries <= 2 * QUERIES, "You may use at most ", QUERIES,
			        " queries. Aborting at ", 2 * QUERIES, ".");
			v.space();
			P a{};
			a.x = v.read_integer("ax", 1, W);
			v.space();
			a.y = v.read_integer("ay", 1, H);
			v.newline();

			auto dotprod = area(p, q, a);
			if(dotprod == 0)
				cout << "horizon" << endl;
			else if(dotprod > 0)
				cout << "sky" << endl;
			else if(dotprod < 0)
				cout << "sea" << endl;
			else
				assert(false);
		} else if(op == "!") {
			P a{}, b{};
			a.x = v.read_integer("ax", 1, W);
			v.space();
			a.y = v.read_integer("ay", 1, H);
			v.space();
			b.x = v.read_integer("bx", 1, W);
			v.space();
			b.y = v.read_integer("by", 1, H);
			v.newline();

			v.check(a.x != b.x or a.y != b.y, "The two answer points should not be the same!");
			v.check(area(p, q, a) == 0, "First point ", a.x, ", ", a.y,
			        " does not lie on the horizon!");
			v.check(area(p, q, b) == 0, "Second point ", b.x, ", ", b.y,
			        " does not lie on the horizon!");
			break;
		}
	}
	v.check(queries <= QUERIES, "You may use at most ", QUERIES, " queries. Used ", queries, ".");
	std::cerr << "Queries used: " << queries << std::endl;
}
