/*
 * @EXPECTED_RESULTS@: CORRECT
 */
import java.io.*;
import java.util.*;

public class jeroen2
{
	public static int N;
	public static int[] M;
	public static Point[][] pt;

	public static void main(String[] args)
	{
		Scanner sc = new Scanner(System.in);
		int tests = sc.nextInt();
		while (tests-- > 0)
		{
			N = sc.nextInt();
			int S = sc.nextInt();
			int D = sc.nextInt();
			M = new int[N];
			pt = new Point[N][];
			for(int i = 0; i < N; i++)
			{
				M[i] = sc.nextInt();
				pt[i] = new Point[M[i]];
				for(int j = 0; j < M[i]; j++)
					pt[i][j] = new Point(sc);
			}

			double[][] dist = new double[N][N];
			for(int i = 0; i < N; i++)
				for(int j = i + 1; j < N; j++)
					dist[i][j] = dist[j][i] = PolyDist(i, j);
			for(int i = 0; i < N; i++)
				for(int j = 0; j < N; j++)
					for(int k = 0; k < N; k++)
						dist[j][k] = Math.min(dist[j][k], dist[j][i] + dist[i][k]);
			System.out.println(String.format("%.3f", dist[S-1][D-1]));
		}
	}

	public static double PolyDist(int i, int j)
	{
		double res = Double.MAX_VALUE;
		for(int g = 0; g < M[i]; g++)
		{
			for(int h = 0; h < M[j]; h++)
			{
				res = Math.min(res, LinePointDist(pt[i][g], pt[i][(g+1)%M[i]], pt[j][h], true));
				res = Math.min(res, LinePointDist(pt[j][h], pt[j][(h+1)%M[j]], pt[i][g], true));
			}
		}
		return res;
	}

	private static class Point
	{
		public int X, Y;

		public Point(Scanner sc)
		{
			X = sc.nextInt();
			Y = sc.nextInt();
		}
	}

	public static double Distance(Point A, Point B)
	{
		return Math.sqrt((A.X - B.X) * (A.X - B.X) + (A.Y - B.Y) * (A.Y - B.Y));
	}

	/* Distance from line L1-L2 to P
	 * If isSegment, the line is taken as a segment */
	public static double LinePointDist(Point L1, Point L2, Point P, boolean isSegment)
	{
		if (isSegment)
		{
			if ((P.X - L2.X) * (L2.X - L1.X) + (P.Y - L2.Y) * (L2.Y - L1.Y) > 0) return Distance(L2, P);
			if ((P.X - L1.X) * (L1.X - L2.X) + (P.Y - L1.Y) * (L1.Y - L2.Y) > 0) return Distance(L1, P);
		}
		return Math.abs(((L2.X - L1.X) * (P.Y - L1.Y) - (L2.Y - L1.Y) * (P.X - L1.X)) / Distance(L1, L2));
	}
}
