// Solution to Annoying Mosquitos
// Author: Thomas Beuman

// Time complexity: O(n*m)
// Memory: O(n)

// @EXPECTED_RESULTS@: CORRECT

// Solution method: simulate all swats, but with bit representation

#include <cstdio>
#include <cstring>
#include <algorithm>
using namespace std;

int X[100], Y[100];
unsigned int Hit[2001][2001/32];
const unsigned int zero = 0, one = 1;

int main()
{ int cases, casenr, n, m, i, j, k, x, y, t, first, last, zone_first, zone_last;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%d\n", &n);
    for (i = 0; i < n; i++)
    { scanf("%d %d\n", &x, &y);
      X[i] = 1000 + x;
      Y[i] = 1000 + y;
    }
    scanf("%d\n", &m);
    // Simulate all swats
    memset(Hit, 0, sizeof(Hit));
    for (j = 0; j < m; j++)
    { scanf("%d %d\n", &x, &y);
      x += 1000;
      y += 1000;
      first = max(y-50, 0);
      last = min(y+50, 2000);
      zone_first = (~zero) << (first%32);
      zone_last = (~zero) >> (31-last%32);
      for (i = max(x-50, 0); i <= x+50 && i <= 2000; i++)
      { Hit[i][first/32] |= zone_first;
        for (k = first/32 + 1; k < last/32; k++)
          Hit[i][k] |= ~zero;
        Hit[i][last/32] |= zone_last;
      }
    }
    // Count the number of dead mosquitos
    t = 0;
    for (i = 0; i < n; i++)
      if (Hit[X[i]][Y[i]/32] & (one << Y[i]%32))
        t++;
    printf("%d\n", t);
  }
  return 0;
}

