#include "testlib.h"
/***************************************************************
**
**         ---- Jury's checker for the problem ----
**
**                --  "Protoss Defense"  --
**
**  file: check.cpp
**
**  13 july     2007 - created
**
***************************************************************/

#include <iostream>

//--------------------------------------------------------------

#define IFN "defense.in"
#define OFN "defense.out"

#define N 512
#define oo 1000000000

//--------------------------------------------------------------

using namespace std;

int n, m, K;
int G[N][N], C[N], L[N];
int got[N];

void Check()  {
	int i, j, p, q, _;
	int JuryAns, GivenAns, GivenN, RealAns(0);

	n = inf.readInt();
	m = inf.readInt();
	K = inf.readInt();

	if( n<=0 || n > 200) quit(_fail, "Number n is incorrect");
	if( m<0 || m > 40000) quit(_fail, "Number m is incorrect");
	if( K<0 || K >= 200) quit(_fail, "Number K is incorrect");

	for(i=1; i<=n; i++) {
		C[i] = inf.readInt();
		if(C[i] < - 1000000 || C[i] > 1000000) quit(_fail, "C[i] is incorrect");
	}

	for(i=1; i<=n; i++) {
		L[i] = inf.readInt();
		if(L[i] < 1 || L[i] > K+1) quit(_fail, "L[i] is incorrect");
	}

	for(i=0; i<m; i++) {
		p = inf.readInt();
		q = inf.readInt();
		if(p<1 || p>n) quit(_fail, "p is incorrect");
		if(q<1 || q>n) quit(_fail, "q is incorrect");
		if(L[p] <= L[q]) quit(_fail, "L[p]<=L[q] is incorrect");
		G[p][q] = 1;
	}
	
	JuryAns = ans.readInt();
	GivenAns = ouf.readInt();
	GivenN = ouf.readInt();
	
	p=0;
	for(i=1; i<=GivenN; i++) {
		q = ouf.readInt();
		got[q]=1;		
		if(p>=q)  {  quit(_pe, "Choosen targets should go in ascending order"); return;  }
		p = q;
	}
	
	for(i=1; i<=n; i++) {
		if(got[i]==0)  continue;
		RealAns += C[i];
		for(j=1; j<=n; j++)
			if(i!=j && G[i][j]>0 && got[j]==0)  quit(_wa, "Choosen target is being protected by unchoosen one");
	}

	if(RealAns > JuryAns) {
		quit(_fail, "Jury's solutin is wrong!!! -- begin panic");
		return;
	}

	if(RealAns != GivenAns) {
		quit(_wa, "Given answer is incorrect");
		return;
	}
	
	
	if ( JuryAns != GivenAns )  { 
		quit(_wa, "Answers differ");
		return;
	}
	
	quit(_ok, "Correct answer... kick author out");
}

int main(int argc, char *argv[])  {

//	inf.init(argv[1], _input);
//	ouf.init(argv[2], _output);
//	ans.init(argv[3], _answer);
	registerTestlibCmd (argc, argv);

	Check();

	return 0;
}
