    #include <cstdio>
    #include <algorithm>
    #include <string>
    #include <vector>
    #include <iostream>
    #include <cstring>
    using namespace std;
    typedef long long i64;
     
    int in() { int x; scanf("%d", &x); return x; }
     
    struct Pt {
    double x, y;
    Pt(double x, double y) : x(x), y(y) { }
    Pt operator+(const Pt& a) const { return Pt(x + a.x, y + a.y); }
    Pt operator-(const Pt& a) const { return Pt(x - a.x, y - a.y); }
    Pt operator*(const double k) const { return Pt(x*k, y*k); }
    Pt operator/(const double k) const { return Pt(x / k, y / k); }
    double dot(const Pt& a) const { return x*a.x + y*a.y; }
    double det(const Pt& a) const { return x*a.y - y*a.x; }
    };
     
    Pt pLL(Pt a, Pt b, Pt c, Pt d) {
    b = b - a;
    d = d - c;
    return a + b * (c - a).det(d) / b.det(d);
    }
     
    typedef vector<Pt> value;
     
    char S[128];
     
    value op(value a, value b) {
    if (a.size() == 1 && b.size() == 1) {
    a.push_back(b[0]);
    return a;
    }
    else if (a.size() == 2 && b.size() == 2) {
    Pt p = pLL(a[0], a[1], b[0], b[1]);
    value v;
    v.push_back(p);
    return v;
    }
    else {
    if (a.size() == 2) {
    swap(a, b);
    }
    double d1 = (b[1] - b[0]).dot(a[0] - b[0]);
    double d2 = (b[1] - b[0]).dot(b[1] - b[0]);
    Pt pp = b[0] + (b[1] - b[0]) * (d1 / d2);
    Pt qq = pp + (pp - a[0]);
    value v;
    v.push_back(qq);
    return v;
    }
    }
     
    pair<int, int> parse_num(int f) {
    int sig = 1, n = 0;
    if (S[f] == '-') {
    sig = -1;
    ++f;
    }
    while (isdigit(S[f])) {
    n = n * 10 + S[f] - '0';
    ++f;
    }
    return make_pair(sig * n, f);
    }
     
    value parse(int fr, int to) {
    vector<int> pos;
    int dep = 0;
    for (int i = fr; i < to; ++i) {
    if (S[i] == '(') ++dep;
    if (S[i] == ')') --dep;
    if (dep == 0 && S[i] == '@') {
    pos.push_back(i);
    }
    }
     
    if (pos.empty()) {
    if (isdigit(S[fr + 1]) || S[fr + 1] == '-') {
    auto tmpx = parse_num(fr + 1);
    auto tmpy = parse_num(tmpx.second + 1);
    Pt p(tmpx.first, tmpy.first);
    value v;
    v.push_back(p);
    return v;
    }
    else {
    return parse(fr + 1, to - 1);
    }
    }
    else {
    value res = parse(fr, pos[0]);
    pos.push_back(to);
    for (int i = 1; i < pos.size(); ++i) {
    res = op(res, parse(pos[i - 1] + 1, pos[i]));
    }
    return res;
    }
    }
     
    int main() {
    while (scanf("%s", S), S[0] != '#') {
    value v = parse(0, strlen(S));
    printf("%.9f %.9f\n", v[0].x, v[0].y);
    }
     
    return 0;
    }

