#include <bits/stdc++.h>
using namespace std;

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

#define fi first
#define se second

typedef long long ll;
typedef long double ld;
typedef pair<int, int> pii;
typedef pair<ll, ll> pll;
typedef vector<int> vi;

const ld INF = 1e19;

bool ccw(const pii& x, const pii& y, const pii& z) {
    return (ll)x.fi * (y.se - z.se)
         + (ll)y.fi * (z.se - x.se)
         + (ll)z.fi * (x.se - y.se) > 0;
}

bool smaller(const pll& x, const pll& y) {
    return x.fi * y.se < y.fi * x.se;
}

vector<pll> compute(const vector<pii>& p, int h) {
    int n = p.size();
    vector<pii> hull;
    vector<pll> a(n / 2 - 1);

    for (int i = 1; i < n - 1; i++) {
        while (hull.size() >= 2
                && ccw(hull.rbegin()[1], hull.rbegin()[0], p[i])) {
            hull.pop_back();
        }
        hull.push_back(p[i]);
        
        if (!(i & 1)) {
            auto [x0, y0] = hull.rbegin()[0];
            auto [x1, y1] = hull.rbegin()[1];
            pll x = {(ll)(x0 - x1) * (h - y1) + (ll)x1 * (y0 - y1), y0 - y1};
            a[i / 2 - 1] = x;
        }
    }

    return a;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n, h;
    cin >> n >> h;
    vector<pii> p(n);
    for (int i = 0; i < n; i++) cin >> p[i].fi >> p[i].se;

    auto a = compute(p, h);

    reverse(p.begin(), p.end());
    for (auto& it : p) it.fi *= -1;
    auto b = compute(p, h);
    reverse(b.begin(), b.end());
    for (auto& it : b) it.fi *= -1;

    vector<pair<pll, pll>> q(n / 2 - 1);
    for (int i = 0; i < n / 2 - 1; i++) q[i] = {a[i], b[i]};

    sort(q.begin(), q.end(),
            [](const pair<pll, pll>& x, const pair<pll, pll>& y) {
                return smaller(x.se, y.se);
            }
        );

    int sol = 0;
    pll last;
    bool is_first = true;
    for (auto& it : q) {
        if (is_first || smaller(last, it.fi)) {
            sol++;
            last = it.se;
            is_first = false;
        }
    }

    cout << sol << '\n';

    return 0;
}

