#include <iostream>
using namespace std;

#define MAXN 1000000
#define rep(i,n) for(int i=0;i<(n);i++)
#define min(a,b) ((a)<(b)?(a):(b))
#define sf(n)       scanf("%d", &n)

int main() {
    // A O(n) solution to the sandpaper problem
    int n;
    sf(n);

    int *width = new int[n];
    int *mins = new int[n];

    // Read input and swipe right over in mins
    rep(i, n) {
        sf(width[i]);
        mins[i] = i == 0 ? width[i] : min(width[i], mins[i-1] + 1);
    }

    // Swipe left over mins
    for (int i = n - 2; i >= 0; i--) {
        mins[i] = min(mins[i], mins[i+1] + 1);
    }

    long long ans = 0;
    rep(i, n) {
        ans += (width[i] - mins[i]);
    }

    fprintf(stdout, "%lld\n", ans);
    return 0;
}
