#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

bool compareEnd(const vector<int>& a, const vector<int>& b) {
    return a[1] < b[1];
}

int main() {
    int n;
    scanf("%d", &n);
    vector<vector<int>> intervals(n, vector<int>(3, 0));
    for (int i = 0; i < n; i++) {
        int s, e, a;
        scanf("%d %d %d", &s, &e, &a);
        intervals[i][0] = s;
        intervals[i][1] = e;
        intervals[i][2] = a;
    }

    sort(intervals.begin(), intervals.end(), compareEnd);

    vector<int> p(n, -1);
    for (int i = 0; i < n; i++) {
        for (int j = i - 1; j >= 0; j--) {
            if (intervals[j][1] <= intervals[i][0]) {
                p[i] = j;
                break;
            }
        }
    }

    vector<long long int> opt(n, 0);
    for (int i = 0; i < n; i++) {
        long long int a = p[i] == -1 ? intervals[i][2] : intervals[i][2] + opt[p[i]];
        long long int b = i == 0 ? 0 : opt[i - 1];
        opt[i] = max(a, b);
    }

    cout << opt[n - 1] << endl;

    return 0;
}