#!/usr/bin/env python3
import sys, argparse, random

def main():
    parser = argparse.ArgumentParser(description="Generator for the fundraiser problem.")
    parser.add_argument('-t', metavar='T', type=int, required=True, help='length of concert')
    parser.add_argument('-n', metavar='N', type=int, required=True, help='number of artists')
    parser.add_argument('-a', metavar='A', type=int, required=True, help='the maximum attention for one artist')
    parser.add_argument('-s', metavar='S', type=int, required=True, help='seed')
    parser.add_argument('-g', metavar='G', type=str, required=True, help='generator')
    args = parser.parse_args()

    random.seed(args.s)

    if args.g == 'random':
        random_concerts(args)
    elif args.g == 'all':
        all_concerts(args)
    elif args.g == 'short':
        short_concerts(args)

def random_concerts(args):
    print(args.n)
    for _ in range(args.n):
        start = random.randint(0, args.t-1)
        end = random.randint(start+1, args.t)
        attention = random.randint(1, args.a)
        print(start, end, attention)

def all_concerts(args):
    previous_concert_end = 0
    count = 0
    concerts = []

    while True:
        start = random.randint(previous_concert_end, previous_concert_end + 10)
        length = random.randint(5, 50)
        attention = int(length * (random.randint(5, 20) / 10))
        end = start + length
        previous_concert_end = end

        if end > args.t:
            break
        
        concerts.append((start, end, attention))
        count += 1

        if count == args.n:
            break
    
    print(count)
    for s, e, a in concerts:
        print(s, e, a)

def short_concerts(args):
    previous_concert_start = 0
    previous_concert_end = 0
    count = 0
    concerts = []

    while True:
        start = random.randint(previous_concert_start, previous_concert_end)
        length = random.randint(5, 15)
        end = start + length
        attention = int(length * (random.randint(5, 20) / 10))
        previous_concert_start = start
        previous_concert_end = end

        if end > args.t:
            break
        
        concerts.append((start, end, attention))
        count += 1

        if count == args.n:
            break
    
    print(count)
    for s, e, a in concerts:
        print(s, e, a)

if __name__ == "__main__":
    main()
