#!/usr/bin/env python3
def solve(twos, threes):
    hundreds = 0
    
    # find total amount of 32 threes and 2 twos pairs we
    # can make to get 100s.
    max_96s = min(twos // 2, threes // 32)

    # update values
    hundreds += max_96s
    twos -= max_96s * 2
    threes -= max_96s * 32

    # Can't make 100s out of only 3s so if no more twos we done
    if (twos < 2):
        return hundreds

    # If there are more threes, use them up first
    if (threes > 1):
        # if there are odd amount of threes just remove one of them
        if threes % 2 == 1:
            threes -= 1
        needed_twos = (100 - (threes * 3)) // 2
        if twos >= needed_twos:
            hundreds += 1
            twos -= needed_twos
    
    # use up the rest of the twos if possible
    hundreds += twos // 50
    
    return hundreds

twos, threes = map(int, (input().split()))
print(solve(twos, threes))
