#!/usr/bin/env python3
import sys

def verify(it_is_true):
    if not it_is_true:
        sys.exit(43)

n, k = map(int, input().split())
items = list(input().split())
order = list(input().split())

# Categories are unique
verify(len(order) == len(set(order)))
verify(len(order) == k)

described_items_count = 0
described_items_set = set()
categories_described = set()
for _ in range(k):
    line = input().split()
    cat = line[0]
    categories_described.add(cat)
    described_items_count += int(line[1])

    for item in line[2:]:
        described_items_set.add(item)

# The described categories are unique, and are the same as those in the order
verify(len(categories_described) == k)
sorted_order = sorted(order)
sorted_described = sorted(categories_described)
for i, cat in enumerate(sorted_order):
    verify(cat == sorted_described[i])

# Each described item belongs to exactly one category
verify(described_items_count == len(described_items_set))

# Verify number of described items is correctly bounded
verify(described_items_count <= 10**5)

# Every bought item is contained in a category
for item in items:
    verify(item in described_items_set)

# Accept
sys.exit(42)
