#!/usr/bin/env python3
import sys, argparse, random

def main():
    parser = argparse.ArgumentParser(description="Generator for categories and items in categories.")
    parser.add_argument('-n', metavar='N', type=int, required=True, help='number of items in the shopping list')
    parser.add_argument('-k', metavar='K', type=int, required=True, help='number of categories')
    parser.add_argument('-s', metavar='S', type=int, default=None, help='seed')
    args = parser.parse_args()

    task = shopping_list_generator(args.n, args.k, args.s)
    # prints first line consisting of n and k
    print(str(args.n) + " " + str(args.k))
    # print all the generated lines
    for line in task:
        print(" ".join(line))

def shopping_list_generator(n, k, seed):
    random.seed(seed)

    # Format for the task to be returned
    # 1: The items that has been bought
    # 2: Categories in sorting order
    # 3: k lines with categories and their items
    task = [[] for _ in range(k + 2)]

    # generate n + k unique strings to be used for
    # categories and items
    items = []
    for i in range(n + k):
        item = ""
        letter = i
        item += chr(65 + (letter % 26))

        while (letter > 0):
            letter = letter // 26
            item += chr(65 + (letter % 26))
        
        items.append(item)
    
    # shuffle the list and pick the first k as categories
    random.shuffle(items)
    task[1] = items[:k]

    # add the categories to line and a count of how many
    # items are assigned into the cateogry
    # add an item to each category as well
    for i in range(0, k):
        task[i + 2].append(items[i])
        task[i + 2].append(1)
        task[i + 2].append(items[k+i].lower())

    # put the remaining strings (items) randomly into the categories
    # and increase the count of items in the given category
    for i in range(k + k, n + k):
        category = random.randrange(2, k + 2)
        task[category].append(items[i].lower())
        task[category][1] += 1

    # create a randomized shoppinglist of the times
    for i in range(n):
        item = random.randrange(k, n + k)
        task[0].append(items[item].lower())

    # convert the final count to strings
    for i in range(k):
        task[i + 2][1] = str(task[i + 2][1])

    return task

if __name__ == "__main__":
    main()
