///
// Created by Brigt Håvardstun on 03/10/2021.
//

#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace  std;
// Using the fancy formula, but bruteforce searching

long long time_spent_in_segment(long long different_tiers, long long rounds_per_tier ,long long base_time,long long tier_wear){
    // No pit stop time included
    /*
    Do some math, get om answers.
            P = different_tiers -1 = pitstops
    p = pit_stop_time
    N = Total laps
    J = N/P distance each tier
    r = base_time
    b = tier_degrading


    unoptimized formula used:
    f(*) = P*p + (P+1)*sum(b*i^2 + r)[i=0 to i=J-1]
    */

 

    long long time_wout_wear = rounds_per_tier*base_time;

    long long extra_time_due_to_tier_wear =tier_wear*(rounds_per_tier-1)*(rounds_per_tier)/2;
    long long total_time = time_wout_wear + extra_time_due_to_tier_wear;
    return total_time*different_tiers;

}
/*
long long time_spent_in_segment_slow(long long different_tiers, long long rounds_per_tier ,long long base_time,long long tier_wear){
    long long total = 0;
    long long i;
    for(i=0; i<rounds_per_tier; i++){
        total += tier_wear*i*i + base_time;
    }
    total *= different_tiers;
    return total;
}
*/
struct Race_split{
    long long tiers_first;
    long long lap_length_first;
    long long tiers_second;
    long long lap_length_second;
};
Race_split get_race_strategy(long long pit_stops, long long number_laps) {
    long long different_tiers = pit_stops + 1;
    long long a, b, x, y;


    if (number_laps % different_tiers == 0) {
        // length on every tiers
        a = number_laps / different_tiers;
        x = different_tiers;
        b = 0;
        y = 0;
    } else {
        //Two different set of tier lengths
        a = ceil((number_laps+0.0) / different_tiers);
        b = floor((number_laps+0.0) / different_tiers);
        x = number_laps - b * different_tiers;
        y = a * different_tiers - number_laps;
    }
    Race_split race_split;
    race_split.tiers_first = x;
    race_split.lap_length_first = a;
    race_split.tiers_second = y;
    race_split.lap_length_second = b;

    return race_split;
}

long long total_time_spent(long long number_of_pit_stops,long long total_rounds, long long pit_time, long long base_time, long long tier_wear){
    /*

     First, find the best split of racestrategy.

             Then calulate the time spent racing each of them.

     return the combined result
     */

    //(pit_time,base_time, tear_factor, total_number_laps) = task_data;
    Race_split raceSplit = get_race_strategy(number_of_pit_stops, total_rounds);
    long long x = raceSplit.tiers_first;
    long long a = raceSplit.lap_length_first;
    long long y = raceSplit.tiers_second;
    long long b = raceSplit.lap_length_second;

    long long time_spent_pitting = pit_time = number_of_pit_stops*pit_time;
    long long time_spent_first_part = time_spent_in_segment( x, a, base_time, tier_wear);
    if(b==0 and y==0) {
        return time_spent_first_part + time_spent_pitting;
    }
    long long time_spent_second_part = time_spent_in_segment(y,b, base_time, tier_wear);

    return time_spent_first_part + time_spent_second_part + time_spent_pitting;
}

long long  solve(long int total_rounds, long int pit_time, long int base_time, long int tier_wear){
    long long nrPits;
    long long lowestTime;
    lowestTime = -1;
    long long bestPitNum = 0;
    for(nrPits=0; nrPits<total_rounds; nrPits++){
        long long timeSpentCurr = total_time_spent(nrPits, total_rounds, pit_time,base_time,tier_wear);
        if(lowestTime == -1 || lowestTime > timeSpentCurr){
            lowestTime = timeSpentCurr;
            bestPitNum = nrPits;
        }
    }
    cout << lowestTime << endl; // Testing<< "nr pits:" << bestPitNum << endl;
    return lowestTime;
}

int main(){
    long long n, p,r,b;
    scanf("%lld %lld %lld %lld", &n,&p,&r,&b);
    solve(n, p, r, b);
    return  0;

}