#!/usr/bin/env python3

# problem: price robot (hard)
# submission author: Torstein Strømme
# submission complexity: O(n log n)

n = int(input())
prices = list(reversed([int(x) for x in input().split()]))

# Flatten the prices (this is only necessary when price range is large)
pricemap = {}
nextPrice = 0
for price in sorted(prices):
    if price not in pricemap:
        pricemap[price] = nextPrice
        nextPrice += 1

# Fairly general functions for a max-value segment tree with point updates and range-up-to queries
def updateMax(index, newValue, segtree, n):
    i = index + n
    segtree[i] = newValue
    i //= 2
    while (i > 0):
        segtree[i] = max(segtree[2*i], segtree[2*i + 1])
        i //= 2

def getMaxUpTo(index, segtree, n):
    # index is not included
    result = -1
    i = index + n
    while (i > 0):
        if (i % 2 == 1):
            result = max(result, segtree[i - 1])
        i //= 2
    return result

# Data structure for the partictular segment tree we will use
np2 = 2
while (np2 < (nextPrice + 1)):
    np2 *= 2
segtree = [-1] * (np2 * 2)

# Computing our results
results = []
for i, p in enumerate(pricemap[price] for price in prices):
    j = getMaxUpTo(p+1, segtree, np2)
    results.append(str(i-j) if j >= 0 else "infinity")
    updateMax(p, i, segtree, np2)

# Printing our results
print("\n".join(reversed(results)))
