#!/usr/bin/env python3
n = int(input())
prices = list(map(int, input().split()))

seg_n = 2
while(seg_n < 2*(max(prices) + 2)):
    seg_n *= 2

offset = seg_n // 2
sa = [float("inf") for _ in range(seg_n)]

def minimum_up_to(i):
    ii = i + offset + 1
    min_value = float("inf")

    while ii > 1:
        if ii % 2 == 1:
            current_value = sa[ii - 1]
            min_value = min(min_value, current_value)
        ii //= 2

    return min_value

def update_index(i, value):
    ii = i + offset
    sa[ii] = value
    ii //= 2
    while ii > 0:
        sa[ii] = min(sa[ii * 2], sa[ii * 2 + 1])
        ii //= 2

results = []

for day, price in reversed(list(enumerate(prices))):
    next_day_lower_or_equals = minimum_up_to(price)
    result = str(next_day_lower_or_equals - day)
    if result == "inf":
        result = "infinity"
    results.append(result)
    update_index(price, day)

print("\n".join(reversed(results)))
