#include <bits/stdc++.h>
using namespace std;

//Using a bad dijkstra (meant for adjancecy matrix) but with a good solution (directed edges from base to water and from food to base)
static int minDistance(vector<int> dist, bool sptSet[], int gridSize)
{
    // Initialize min value
    int min = INT32_MAX, min_index = -1;

    for (int v = 0; v < gridSize; v++)
        if (sptSet[v] == false && dist[v] <= min)
        {
            min = dist[v];
            min_index = v;
        }

    return min_index;
}

static vector<int> dijkstra(vector<pair<int, int>>* adjList, int src, int n)
{
    vector<int> dist(n);

    bool sptSet[n];

    for (int i = 0; i < n; i++)
    {
        dist[i] = INT32_MAX;
        sptSet[i] = false;
    }

    dist[src] = 0;

    for (int count = 0; count < n; count++)
    {
        int u = minDistance(dist, sptSet, n);

        // Mark the picked vertex as processed
        sptSet[u] = true;

        // Update dist value of the adjacent vertices of the
        // picked vertex.
        for (int v = 0; v < adjList[u].size(); v++) {
            if (!sptSet[adjList[u][v].first] && dist[u] != INT32_MAX && dist[u] + adjList[u][v].second < dist[adjList[u][v].first])
               dist[adjList[u][v].first] = dist[u] + adjList[u][v].second;
                
        }
    }
    

    return dist;
}

int main()
{
    int numNodes;
    cin >> numNodes;

    int numLines;
    cin >> numLines;

    int numWaterDepots;
    cin >> numWaterDepots;

    int numFoodDepots;
    cin >> numFoodDepots;

    int waterDepots[numWaterDepots];
    int foodDepots[numFoodDepots];

    for (int i = 0; i < numWaterDepots; i++)
    {
        cin >> waterDepots[i];
    }

    for (int i = 0; i < numFoodDepots; i++)
    {
        cin >> foodDepots[i];
    }
    
    vector<pair<int, int>>* adjacencyList = new vector<pair<int, int>>[numNodes+2]();
    int a;
    int b;
    int w;
    for (int i = 0; i < numLines; i++)
    {
        cin >> a;
        cin >> b;
        cin >> w;
        adjacencyList[a].push_back(make_pair(b, w));
        adjacencyList[b].push_back(make_pair(a, w));
    }
    
    //Find preprocessed using dijkstra
    vector<int> dist_to_water_and_food = dijkstra(adjacencyList, 0, numNodes);

    for (int i = 0; i < numWaterDepots; i++)
    {
        adjacencyList[numNodes].push_back(make_pair(waterDepots[i], dist_to_water_and_food[waterDepots[i]]));
    }

    for (int i = 0; i < numFoodDepots; i++)
    {
        adjacencyList[foodDepots[i]].push_back(make_pair(numNodes+1, dist_to_water_and_food[foodDepots[i]]));
    }

    vector<int> dist = dijkstra(adjacencyList, numNodes, numNodes+2);    
    cout << dist[numNodes+1];
}