#include <bits/stdc++.h>
using namespace std;
typedef pair<int, int> iPair;  

//Using a fast dijkstra but with the solution to dijkstra once for every waterdepot.
static vector<int> dijkstra(vector<pair<int, int>> *adjList, int src, int n)
{
    vector<int> dist(n);

    for (int i = 0; i < n; i++)
    {
        dist[i] = INT32_MAX;
    }

    dist[src] = 0;
    std::priority_queue<pair<int,int>> pq;

    pq.push(make_pair(0, src)); 
    while (!pq.empty())
    {
        int curr = pq.top().second;
        pq.pop();

        for (int v = 0; v < adjList[curr].size(); v++)
        {
            if (adjList[curr][v].second + dist[curr] < dist[adjList[curr][v].first])
            {
                dist[adjList[curr][v].first] = adjList[curr][v].second + dist[curr];
                pq.push(make_pair(adjList[curr][v].second + dist[curr],adjList[curr][v].first));
            }
        }
    }

    return dist;
}

int main()
{
    int numNodes;
    cin >> numNodes;

    int numLines;
    cin >> numLines;

    int numWaterDepots;
    cin >> numWaterDepots;

    int numFoodDepots;
    cin >> numFoodDepots;

    int waterDepots[numWaterDepots];
    int foodDepots[numFoodDepots];

    for (int i = 0; i < numWaterDepots; i++)
    {
        cin >> waterDepots[i];
    }

    for (int i = 0; i < numFoodDepots; i++)
    {
        cin >> foodDepots[i];
    }

    vector<pair<int, int>> *adjacencyList = new vector<pair<int, int>>[numNodes]();
    int a;
    int b;
    int w;
    for (int i = 0; i < numLines; i++)
    {
        cin >> a;
        cin >> b;
        cin >> w;
        adjacencyList[a].push_back(make_pair(b, w));
        adjacencyList[b].push_back(make_pair(a, w));
    }

    //Find preprocessed using dijkstra
    vector<int> preprocessed = dijkstra(adjacencyList, 0, numNodes);
    //cout << preprocessed[1];

    //For each waterdepot I find the shortest distance from the base to the waterdepot and add the distance
    //from the current waterdepot to a fooddepot and then add the way back.
    long shortestDistanceTotal = INT32_MAX;
    for (int i = 0; i < numWaterDepots; i++)
    {
        //Getting the distances from our current waterdepot to all other nodes.
        vector<int> dist = dijkstra(adjacencyList, waterDepots[i], numNodes);
        long bestDistanceFromWaterToFood = INT32_MAX;
        //For every
        for (int j = 0; j < numFoodDepots; j++)
        {
            //Current distance is from base to waterdepot + distance from waterdepot to fooddepot + distance from food to base
            if (preprocessed[waterDepots[i]] < INT32_MAX && dist[foodDepots[j]] < INT32_MAX && preprocessed[foodDepots[j]] < INT32_MAX && preprocessed[waterDepots[i]] >= 0 && dist[foodDepots[j]] >= 0 && preprocessed[foodDepots[j]] >= 0)
            {
                long currentDist = preprocessed[waterDepots[i]] + dist[foodDepots[j]] + preprocessed[foodDepots[j]];
                if (currentDist < bestDistanceFromWaterToFood)
                {
                    bestDistanceFromWaterToFood = currentDist;
                }
            }
        }

        if (bestDistanceFromWaterToFood < shortestDistanceTotal)
        {
            shortestDistanceTotal = bestDistanceFromWaterToFood;
        }
    }
    cout << shortestDistanceTotal;
}
