#!/usr/bin/env python3
import sys

visited = [] # List to keep track of visited nodes.
queue = []     #Initialize a queue

def bfs(visited, graph, node):
    visited.append(node)
    queue.append(node)

    while queue:
        s = queue.pop(0) 

        for neighbour in graph[s]:
            (to, weight) = neighbour
            if to not in visited:
                visited.append(to)
                queue.append(to)
    return visited

n, m, _, _ = map(int, input().split())
_ = list(input().split())
_ = list(input().split())

graph = []
for i in range(n):
    graph.append([])

for i in range(m):
    line = input().split(" ")
    a = int(line[0])
    b = int(line[1])
    w = int(line[2])
    graph[a].append((b, w))
    graph[b].append((a, w))

bfs(visited, graph, 0)

if len(visited) == n:
    # Accept
    sys.exit(42)
else:
    sys.exit(43)
