#!/usr/bin/env python3
n, m, k = [int(x) for x in input().split()]
n += 1 # Adding node 0 as "outside"
targets = [int(x) for x in input().split()]
targets_norepeats = set(targets)
edges = [tuple(map(int, input().split())) for _ in range(m)]

adj_list = [set([i]) for i in range(n)]
for u, v in edges:
    adj_list[u].add(v)
    adj_list[v].add(u)

# For ease of debugging, let neighours adj_list contain neighborhoods in sorted order.
adj_list = [list(sorted(adj_list[i])) for i in range(len(adj_list))]

def get_neighbors(u, day, days, adj_mtx):
    """ For a node (u, day), return the list of neighbour nodes that is 
    reachable with edges of non-negative weights.
    """
    if day == days and u in targets_norepeats:
        # Check forward edges to sink. If this edge is here, it is the
        # only edge that matters, so it is ok to return immediately.
        if adj_mtx[u][0][2*day] > 0:
            return [(0, days + 1)]

    nbrs = []
    if day < days:
        # Check forward edges from day to day+1
        for v in adj_list[u]:
            if adj_mtx[u][v][2*day] > 0:
                nbrs.append((v, day+1))
    
    if day > 0:
        # Check backward edges from day to day-1
        for v in adj_list[u]:
            if adj_mtx[v][u][2*day-1] > 0:
                nbrs.append((v, day-1))

    return nbrs

def can_move_in_days(days):
    adj_mtx = [[[0] * (2*days + 2) for _ in range(n)] for _ in range(n)]
    # adj_mtx[u][v][2i] represents edge from u_i to v_{i+1}
    # adj_mtx[u][v][2i+1] represents edge from v_{i+1} to u_i (initially 0)
    # Node 0_{days+1} is special, represents the sink.

    # Adding edges to sink:
    for target in targets:
        adj_mtx[target][0][2*days] += 1

    # Add edges with inf capacity to next day
    for lev in range(days):
        for u in range(n):
            adj_mtx[u][u][2*lev] = k

    # Adding edges for other levels:
    for lev in range(days):
        for u, v in edges:
            adj_mtx[u][v][2*lev] += 1
            adj_mtx[v][u][2*lev] += 1

    # DEBUG
    # print("The graph")
    # for row in adj_mtx:
    #     print(row)
    

    # Run simple max flow
    def find_and_saturate():
        source = (0, 0)
        sink = (0, days+1)

        parent = {}
        explored = set()
        queue = [source]
        i = 0
        while i < len(queue) and sink not in parent.keys():
            u, day = queue[i]
            i += 1
            if (u, day) in explored:
                continue
            explored.add((u, day))
            for v, v_day in get_neighbors(u, day, days, adj_mtx):
                if (v, v_day) not in parent.keys():
                    parent[(v, v_day)] = (u, day)
                    queue.append((v, v_day))

        if sink not in parent.keys():
            return False

        # Push flow
        here = sink
        path = []
        while (here != (0, 0)):
            c_u, c_day = here
            p_u, p_day = parent[here]

            if (c_day == p_day + 1):
                # Going forward
                adj_mtx[p_u][c_u][2*p_day] -= 1
                adj_mtx[p_u][c_u][2*p_day + 1] += 1
            elif (c_day + 1 == p_day):
                # Going backwards
                adj_mtx[c_u][p_u][2*c_day] += 1
                adj_mtx[c_u][p_u][2*c_day + 1] -= 1
            else:
                raise Exception("Something fishy")

            here = (p_u, p_day)
        return True

    count = 0
    while find_and_saturate():
        count += 1

    return count == k


# Binary search
can_not = 0
can_do = n + k + 2
while can_not + 1 < can_do:
    guess = (can_not + can_do) // 2
    if (can_move_in_days(guess)):
        can_do = guess
    else:
        can_not = guess

print(can_do)
