#include <iostream>
using namespace std;

#define rep(i,n) for(int i=0;i<(n);i++)
#define sf(n)       scanf("%d", &n)

int explore(int **graph, int *nbours, bool *visited, int node) {
    if (visited[node]) return 0;
    visited[node] = true;
    int res = 1;
    rep(i, nbours[node]) res += explore(graph, nbours, visited, graph[node][i]);
    return res;
}

int main() {
    // Checking wheter graph is connected
    
    // Read input
    int n, m, k;
    scanf("%d %d %d", &n, &m, &k);
    n++;

    int *targets = new int[k];
    int *edgesU = new int[m];
    int *edgesV = new int[m];

    rep(i, k) sf(targets[i]);
    rep(i, m) scanf("%d %d", &edgesU[i], &edgesV[i]);

    // Build graph
    int *nbours = new int[n];
    rep(i, n) nbours[i] = 0;
    rep(i, m) nbours[edgesU[i]]++;
    rep(i, m) nbours[edgesV[i]]++;

    int **graph = new int*[n];
    rep(i, n) graph[i] = new int[nbours[i]];
    int *gi = new int[n](); // Adding () at end initialize to 0
    rep(i, m) {
        int u = edgesU[i];
        int v = edgesV[i];
        graph[u][gi[u]++] = v;
        graph[v][gi[v]++] = u;
    }

    // Check that everything is connected
    bool *visited = new bool[n]();
    int found = explore(graph, nbours, visited, 0);

    if (found == n) {
        return 42;
    }
    else {
        return 43;
    }
}
