#!/usr/bin/env bash

### Master generator (run this from the ./generators folder to generate)
MAXN=100
MAXK=8
MAXM=400

## Solver
# g++ -O2 ../submissions/accepted/torstein.cpp -o /tmp/a.out
SOLVER=../submissions/accepted/petter.py

## Destination for generated files
# CAREFUL! EVERYTHING IN THIS DIRECTORY WILL BE ERASED
DESTBASE="../data/secret/gen"
rm -r -f $DESTBASE
mkdir $DESTBASE
DEST="${DESTBASE}"

# Calling the generation script
COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    echo n=$1 m=$2 k=$3 shuffle=$4 options=$5
    ./gen_undir_graph.py -s $COUNT -n $1 -p True -c True -m $2 -k $3 -u $4 -o $5 > $DEST/${padCount}.in
    echo n=$1 m=$2 k=$3 shuffle=$4 options=$5 > $DEST/${padCount}.desc
}

# Call generator with these flags
for n in 5 $MAXN
do
    generate $n $n 1 false path
    generate $n $n 3 false path
    generate $n $n $MAXK true path
    generate $n $((2*n)) 4 false path-path
    generate $n $((2*n)) 4 false path-star
    generate $n $((n+1)) 5 true hamcycle
    generate $n $((n+5)) 5 true hamcycle-random
    generate $n $n $MAXK false path
    generate $n $((2*n)) $MAXK false sausage
    generate $n $((2*n)) $MAXK true sausage
    generate $n $((3*n)) $MAXK false sausage2
    generate $n $((3*n)) $MAXK false sausage3
    generate $n $((3*n)) $MAXK true sausage3
    generate $n $n $MAXK false binarytree
    generate $n $((2*n)) $MAXK true binarytree-binarytree
    generate $n $n $MAXK true binarytree-extraZeroEdges3
    generate $n $n $MAXK true path-extraZeroEdges2
    generate $n $n $MAXK true path-extraZeroEdges3
    generate $n $n 4 false star
    generate $n $n 4 true star
    generate $n $((n+1)) $MAXK false hamcycle
    generate $n $((n+1)) $MAXK true hamcycle
    generate $n $((5*n/4+1)) $MAXK true hamcycle-random
    generate `echo "sqrt(2 * $MAXM) - 1" | bc` $MAXM $MAXK true clique
    generate `echo "sqrt(2 * $MAXM) - 2" | bc` $MAXM $MAXK true clique-tree
    generate $n $MAXM $MAXK true path-random
    generate $n $((MAXM-4)) $MAXK true binarytree-random-extraZeroEdges4
    generate $n $MAXM $MAXK true star-random
    generate $n $MAXM $MAXK false sqrstar
    generate $n $MAXM $MAXK true sqrstar
    generate $n $MAXM $MAXK true sqrstar-random
    generate $n $((5*n/3)) $MAXK true path-random-extraZeroEdges1
    generate $n $((5*n/3)) $MAXK true star-random-extraZeroEdges2
    generate $n $((n + 10)) $MAXK true sqrstar-random
    generate $n $n $MAXK true sqrstar-random-extraZeroEdges10
done

# Generate solutions
if [[ ! -z $SOLVER ]]
then
    for f in $DEST/*.in
    do
        echo "solving $f"
        $SOLVER < $f > ${f%???}.ans
    done
fi
